/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.fillingcurve.FillingCurve2D;
import cds.healpix.fillingcurve.FillingCurve2DType;
import cds.healpix.fillingcurve.ZOrderCurve2DImpls;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public final class Tile2HPX {
    public final FillingCurve2D fc = ZOrderCurve2DImpls.ZOC_VMSB_LOOKUP_INT;
    private final int order;
    private final int inNside;
    private final WCSFrame frame;
    private final int nsideTile;
    private final int nsidePix;
    private final int twiceDepth;
    private final long xyMask;

    public Tile2HPX(int tileOrder, int inTileNside, WCSFrame wcsFrame) {
        FillingCurve2DType.Z_ORDER_LUPT.get(tileOrder);
        this.order = tileOrder;
        this.inNside = inTileNside;
        this.frame = wcsFrame;
        this.nsideTile = 1 << this.order;
        this.nsidePix = this.nsideTile * this.inNside;
        this.twiceDepth = tileOrder << 1;
        this.xyMask = (1L << this.twiceDepth) - 1L;
    }

    public void center(long hash, double[] xyResult) {
        int d0h = (int)(hash >> this.twiceDepth);
        hash = this.fc.hash2ij(hash & this.xyMask);
        int iInD0h = this.fc.ij2i(hash);
        int jInD0h = this.fc.ij2j(hash);
        int lInD0h = iInD0h - jInD0h;
        int hInD0h = iInD0h + jInD0h - (this.nsideTile - 1);
        int d0hBy4Quotient = d0h >> 2;
        int d0hMod4 = d0h - (d0hBy4Quotient << 2);
        int hD0h = 1 - d0hBy4Quotient;
        int lD0h = d0hMod4 << 1;
        if (hD0h == 0 && (lD0h == 6 || lD0h == 4 && lInD0h > 0) || hD0h != 0 && ++lD0h > 3) {
            lD0h -= 8;
        }
        xyResult[0] = 0.7853981633974483 * ((double)lD0h + (double)lInD0h / (double)this.nsideTile);
        xyResult[1] = 0.7853981633974483 * ((double)hD0h + (double)hInD0h / (double)this.nsideTile);
    }

    public final Map<String, String> toFitsHeader(long tileIpix) throws Exception {
        double[] xy = new double[2];
        this.center(tileIpix, xy);
        double centreX = Math.toDegrees(xy[0]);
        double centreY = Math.toDegrees(xy[1]);
        double scale = 45.0 / (double)this.nsidePix;
        double crPix1 = (double)(this.inNside + 1) / 2.0 - 0.5 * (-centreX / scale + centreY / scale);
        double crPix2 = (double)(this.inNside + 1) / 2.0 - 0.5 * (-centreX / scale - centreY / scale);
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        output.put("NAXIS  ", "                    2 / number of data axes");
        output.put("NAXIS1 ", String.format(Locale.US, "%21d / length of data axis 1", this.inNside));
        output.put("NAXIS2 ", String.format(Locale.US, "%21d / length of data axis 1", this.inNside));
        output.put("CRPIX1 ", String.format(Locale.US, "%21.1f / Coordinate reference pixel", crPix1));
        output.put("CRPIX2 ", String.format(Locale.US, "%21.1f / Coordinate reference pixel", crPix2));
        output.put("CD1_1  ", String.format(Locale.US, "%21.13E / Transformation matrix (rot + scale)", -scale));
        output.put("CD1_2  ", String.format(Locale.US, "%21.13E / Transformation matrix (rot + scale)", -scale));
        output.put("CD2_1  ", String.format(Locale.US, "%21.13E / Transformation matrix (rot + scale)", scale));
        output.put("CD2_2  ", String.format(Locale.US, "%21.13E / Transformation matrix (rot + scale)", -scale));
        output.put("CTYPE1 ", " '" + this.frame.lonLabel + "-HPX'           / Longitude in an HPX projection");
        output.put("CTYPE2 ", " '" + this.frame.latLabel + "-HPX'           /  Latitude in an HPX projection");
        output.put("CRVAL1 ", "                   0. / [deg] Longitude at the reference point");
        output.put("CRVAL2 ", "                   0. / [deg]  Latitude at the reference point");
        output.put("PV2_1  ", "                   4  / HPX H parameter (longitude)");
        output.put("PV2_2  ", "                   3  / HPX K parameter  (latitude)");
        return output;
    }

    public static final Map<String, String> toFitsHeader(int tileOrder, long tileIpix, int nPixelX, WCSFrame frame) throws Exception {
        return new Tile2HPX(tileOrder, nPixelX, frame).toFitsHeader(tileIpix);
    }

    public static void main(String[] args) throws Exception {
        int order = Integer.parseInt(args[0]);
        long ipix = Long.parseLong(args[1]);
        int nPixelsX = Integer.parseInt(args[2]);
        Map<String, String> map = Tile2HPX.toFitsHeader(order, ipix, nPixelsX, args.length > 3 ? WCSFrame.valueOf(args[3].toUpperCase()) : WCSFrame.EQU);
        for (Map.Entry<String, String> e : map.entrySet()) {
            System.out.println(e.getKey() + " =" + e.getValue());
        }
    }

    public static enum WCSFrame {
        EQU("RA--", "DEC-"),
        GAL("GLON", "GLAT");

        private final String lonLabel;
        private final String latLabel;

        private WCSFrame(String lonLabel, String latLabel) {
            this.lonLabel = lonLabel;
            this.latLabel = latLabel;
        }
    }
}

